-- On se place dans le contexte de la base master
USE master;
GO
-- On cre la cl matresse de la base master pour crer un certificat
CREATE MASTER KEY ENCRYPTION BY PASSWORD = 'Super Mot 2 Pass.';
GO

-- On cre le certificat qui servira pour crer la cl de cryptage TDE de la base
CREATE CERTIFICATE CERT_TDE_MABASE
   WITH SUBJECT = 'Certificat pour cryptage TDE de MABASE';
GO
-- On sauvegarde la base en mode FULL
BACKUP DATABASE DB_MABASE
   TO DISK = 'C:\MesSauvegardes\DB_MABASE_AVANT_TDE.BAK';
-- et on sauvegarde le journal de la base
BACKUP LOG DB_MABASE
   TO DISK = 'C:\MesSauvegardes\DB_MABASE_AVANT_TDE.TRN';
GO
-- On se place dans le contexte de la base  crypter
USE DB_MABASE;
GO
-- On cre la cl de cryptage TDE de la base
CREATE DATABASE 
   ENCRYPTION KEY WITH ALGORITHM = AES_128
   ENCRYPTION BY SERVER CERTIFICATE CERT_TDE_MABASE;
GO
-- On active le cryptage TDE
ALTER DATABASE DB_MABASE SET ENCRYPTION ON;
GO
-- On sauvegarde  nouveau la base en mode FULL
BACKUP DATABASE DB_MABASE
   TO DISK = 'C:\MesSauvegardes\DB_MABASE_APRES_TDE.BAK';
-- et on sauvegarde le journal de la base
BACKUP LOG DB_MABASE
   TO DISK = 'C:\MesSauvegardes\DB_MABASE_APRES_TDE.TRN';
GO

--> ATTENTION : la possibilit de le stockage d'une base via TDE ne fonctionne qu' partir de la version 2008 de SQL Server